/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.jmx.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import org.apache.logging.log4j.core.helpers.Assert;
import org.apache.logging.log4j.core.jmx.ContextSelectorAdminMBean;
import org.apache.logging.log4j.core.jmx.LoggerContextAdminMBean;
import org.apache.logging.log4j.core.jmx.StatusLoggerAdminMBean;

public class Client {
    private JMXConnector connector;
    private final MBeanServerConnection connection;
    private StatusLoggerAdminMBean statusLoggerAdmin;
    private ContextSelectorAdminMBean contextSelectorAdmin;
    private List<LoggerContextAdminMBean> contextAdminList;

    public Client(JMXConnector connector) throws MalformedObjectNameException, IOException {
        this.connector = (JMXConnector)Assert.isNotNull((Object)connector, (String)"JMXConnector");
        this.connector.connect();
        this.connection = connector.getMBeanServerConnection();
        this.init();
    }

    public Client(MBeanServerConnection mBeanServerConnection) throws MalformedObjectNameException, IOException {
        this.connection = mBeanServerConnection;
        this.init();
    }

    private void init() throws MalformedObjectNameException, IOException {
        this.statusLoggerAdmin = JMX.newMBeanProxy(this.connection, new ObjectName("org.apache.logging.log4j2:type=StatusLogger"), StatusLoggerAdminMBean.class, true);
        this.contextSelectorAdmin = JMX.newMBeanProxy(this.connection, new ObjectName("org.apache.logging.log4j2:type=ContextSelector"), ContextSelectorAdminMBean.class, false);
        this.contextAdminList = new ArrayList<LoggerContextAdminMBean>();
        String pattern = String.format("org.apache.logging.log4j2:type=LoggerContext,ctx=%s", "*");
        ObjectName search = new ObjectName(pattern);
        Set<ObjectName> found = this.connection.queryNames(search, null);
        for (ObjectName contextName : found) {
            LoggerContextAdminMBean ctx = JMX.newMBeanProxy(this.connection, contextName, LoggerContextAdminMBean.class, false);
            this.contextAdminList.add(ctx);
        }
    }

    public ContextSelectorAdminMBean getContextSelectorAdmin() {
        return this.contextSelectorAdmin;
    }

    public List<LoggerContextAdminMBean> getLoggerContextAdmins() {
        return new ArrayList<LoggerContextAdminMBean>(this.contextAdminList);
    }

    public void close() {
        try {
            this.connector.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public MBeanServerConnection getConnection() {
        return this.connection;
    }

    public StatusLoggerAdminMBean getStatusLoggerAdmin() {
        return this.statusLoggerAdmin;
    }
}

